"use client"

import { useEffect, useState } from "react"
import { createClient } from "@/lib/supabase/client"
import { useRouter } from "next/navigation"
import { Menu } from "lucide-react"
import { Button } from "@/components/ui/button"
import { AdminSidebar } from "@/components/admin/sidebar"
import Image from "next/image"
export default function AdminLayout({ children }: { children: React.ReactNode }) {
    const router = useRouter()
    const [isAdmin, setIsAdmin] = useState(false)
    const [loading, setLoading] = useState(true)
    const [sidebarOpen, setSidebarOpen] = useState(false)

    useEffect(() => {
        const checkAdmin = async () => {
            try {
                const supabase = createClient()
                const { data: { user }, error: userError } = await supabase.auth.getUser()

                if (userError || !user) {
                    router.push("/auth/login")
                    return
                }

                const { data: profile } = await supabase.from("profiles").select("is_admin").eq("id", user.id).single()

                if (!profile?.is_admin) {
                    router.push("/")
                    return
                }

                setIsAdmin(true)
            } catch (error) {
                console.error(error)
                router.push("/")
            } finally {
                setLoading(false)
            }
        }

        checkAdmin()
    }, [router])

    if (loading || !isAdmin)
        return (
            <div className="flex items-center justify-center min-h-screen">
                <p className="text-muted-foreground">Loading...</p>
            </div>
        )

    return (
        <div className="flex min-h-screen bg-background dark:bg-background">
            {sidebarOpen && (
                <div
                    className="fixed inset-0 z-40 bg-black/50 lg:hidden"
                    onClick={() => setSidebarOpen(false)}
                />
            )}

            <AdminSidebar
                isOpen={sidebarOpen}
                setIsOpen={setSidebarOpen}
            />

            <div className="flex-1 flex flex-col min-w-0 overflow-hidden">
                <div className="lg:hidden flex items-center p-4 border-b border-border">
                    <Button
                        variant="ghost"
                        size="icon"
                        onClick={() => setSidebarOpen(true)}
                        className="mr-2"
                    >
                        <Menu className="w-6 h-6" />
                    </Button>
                </div>
                <main className="flex-1 overflow-y-auto">
                    {children}
                </main>
            </div>
        </div>
    )
}
