import Link from "next/link"
import { Button } from "@/components/ui/button"

export default function SignUpSuccessPage() {
  return (
    <div className="flex min-h-svh w-full items-center justify-center p-6 md:p-10 bg-background dark:bg-background">
      <div className="w-full max-w-sm text-center">
        <h1 className="text-3xl font-bold text-gold mb-4">Account Created!</h1>
        <p className="text-muted-foreground mb-6">
          Please check your email to confirm your account before booking appointments.
        </p>
        <Link href="/auth/login">
          <Button className="bg-gold hover:bg-gold-dark text-black font-semibold w-full">Back to Login</Button>
        </Link>
      </div>
    </div>
  )
}
