"use client"

import { useState } from "react"
import { Menu, X, Moon, Sun } from "lucide-react"
import { useEffect } from "react"
import Image from "next/image"
import Link from "next/link"

export default function Header() {
  const [isOpen, setIsOpen] = useState(false)
  const [isDark, setIsDark] = useState(false)

  useEffect(() => {
    const isDarkMode = document.documentElement.classList.contains("dark")
    setIsDark(isDarkMode)
  }, [])

  const toggleDarkMode = () => {
    const html = document.documentElement
    html.classList.toggle("dark")
    setIsDark(!isDark)
    localStorage.setItem("theme", isDark ? "light" : "dark")
  }

  return (
    <header className="sticky top-0 z-50 bg-background border-b border-border/40 backdrop-blur-md">
      <nav className="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 h-20 flex items-center">
        <div className="flex justify-between items-center w-full">
          {/* Logo - Fixed dimensions so it doesn't affect header height */}
          <Link href="/#hero" className="flex-shrink-0 cursor-pointer">
            <Image
              src="/Logo/New Project.png"
              alt="United Nails Logo"
              width={160}
              height={70}
              className="object-contain"
              priority
            />
          </Link>

          {/* Desktop Navigation */}
          <div className="hidden md:flex items-center gap-8">
            <a href="#services" className="text-foreground hover:text-gold transition">
              Services
            </a>
            <a href="#gallery" className="text-foreground hover:text-gold transition">
              Gallery
            </a>
            <a href="#about" className="text-foreground hover:text-gold transition">
              About
            </a>
            <a href="#contact" className="text-foreground hover:text-gold transition">
              Contact
            </a>
          </div>

          {/* Actions */}
          <div className="flex items-center gap-4">
            <button
              onClick={toggleDarkMode}
              className="p-2 hover:bg-muted rounded-lg transition"
              aria-label="Toggle dark mode"
            >
              {isDark ? <Sun size={20} /> : <Moon size={20} />}
            </button>
            <button className="hidden sm:inline-block px-6 py-2 bg-gold text-foreground rounded-lg font-medium hover:bg-gold-dark transition">
              Book Now
            </button>

            {/* Mobile Menu Button */}
            <button onClick={() => setIsOpen(!isOpen)} className="md:hidden p-2" aria-label="Toggle menu">
              {isOpen ? <X size={24} /> : <Menu size={24} />}
            </button>
          </div>
        </div>

        {/* Mobile Navigation */}
        {isOpen && (
          <div className="md:hidden mt-4 space-y-3 pb-4 border-t border-border/40 pt-4 px-4 sm:px-6 lg:px-8">
            <a href="#services" className="block text-foreground hover:text-gold transition py-2">
              Services
            </a>
            <a href="#gallery" className="block text-foreground hover:text-gold transition py-2">
              Gallery
            </a>
            <a href="#about" className="block text-foreground hover:text-gold transition py-2">
              About
            </a>
            <a href="#contact" className="block text-foreground hover:text-gold transition py-2">
              Contact
            </a>
            <button className="w-full px-4 py-2 bg-gold text-foreground rounded-lg font-medium hover:bg-gold-dark transition">
              Book Now
            </button>
          </div>
        )}
      </nav>
    </header>
  )
}
