import type { SerializeOptions } from "cookie";
import * as cookie from "cookie";
/**
 * @deprecated Since v0.4.0: Please use {@link parseCookieHeader}. `parse` will
 * not be available for import starting v1.0.0 of `@supabase/ssr`.
 */
export declare const parse: typeof cookie.parse;
/**
 * @deprecated Since v0.4.0: Please use {@link serializeCookieHeader}.
 * `serialize` will not be available for import starting v1.0.0 of
 * `@supabase/ssr`.
 */
export declare const serialize: typeof cookie.serialize;
/**
 * Parses the `Cookie` HTTP header into an array of cookie name-value objects.
 *
 * @param header The `Cookie` HTTP header. Decodes cookie names and values from
 * URI encoding first.
 */
export declare function parseCookieHeader(header: string): {
    name: string;
    value?: string;
}[];
/**
 * Converts the arguments to a valid `Set-Cookie` header. Non US-ASCII chars
 * and other forbidden cookie chars will be URI encoded.
 *
 * @param name Name of cookie.
 * @param value Value of cookie.
 */
export declare function serializeCookieHeader(name: string, value: string, options: SerializeOptions): string;
export declare function isBrowser(): boolean;
/**
 * Returns a localStorage-like object that stores the key-value pairs in
 * memory.
 */
export declare function memoryLocalStorageAdapter(store?: {
    [key: string]: string;
}): {
    getItem: (key: string) => string | null;
    setItem: (key: string, value: string) => void;
    removeItem: (key: string) => void;
};
